//
//  MCTVToolbarButton.h
//  MCApplication
//
//  Created by Ali Lalani on 11/04/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCApplicationDefines.h"

@interface MCTVToolbarButton : NSView {
	NSString *displayString;
	NSImage  *activeImage;
	NSImage  *inactiveImage;
	
	NSMenu *menu;
	
	id target;
	SEL selector;
	SEL enabledSelector;

	MCTVToolbarButtonType buttonType;

	BOOL isPressed;

	NSTimer *animationTimer;
	NSCalendarDate *animationStart;
	
	int pulsationIndex;
	float pulsationFactor;
	float animationPercentDone;
	BOOL reversePulsation;
	
	BOOL usesSystemTheme; // this is to use aqua/graphite instead of the flatter grey background

	NSArray *pulsatingImages;

	float cycleTime;
	int framesPerSecond;
	int imageCount;
}
- (void)commonInit;

- (float)preferredWidth;
- (NSDictionary *)activeTextAttributes;
- (NSDictionary *)inactiveTextAttributes;
- (BOOL)isTextType;
- (BOOL)isImageType;

- (BOOL)isEnabled;

- (void)startPulsating;
- (void)stopPulsating;
- (void)resetPulsatingImages;

#pragma mark Accessors
- (MCTVToolbarButtonType)buttonType;
- (void)setButtonType:(MCTVToolbarButtonType)aButtonType;
- (BOOL)isPressed;
- (void)setIsPressed:(BOOL)flag;
- (NSString *)displayString;
- (void)setDisplayString:(NSString *)aDisplayString;
- (NSImage *)activeImage;
- (void)setActiveImage:(NSImage *)anActiveImage;
- (NSImage *)inactiveImage;
- (void)setInactiveImage:(NSImage *)anInactiveImage;
- (NSMenu *)menu;
- (void)setMenu:(NSMenu *)aMenu;
- (id)target;
- (void)setTarget:(id)aTarget;
- (SEL)selector;
- (void)setSelector:(SEL)aSelector;
- (SEL)enabledSelector;
- (void)setEnabledSelector:(SEL)anEnabledSelector;
- (BOOL)usesSystemTheme;
- (void)setUsesSystemTheme:(BOOL)flag;
- (NSArray *)pulsatingImages;
- (void)setPulsatingImages:(NSArray *)aPulsatingImages;

- (float)imageCount;
- (void)setImageCount:(float)anImageCount;
- (float)cycleTime;
- (void)setCycleTime:(float)aCycleTime;
- (int)framesPerSecond;
- (void)setFramesPerSecond:(int)aFramesPerSecond;
@end
